package tictactoe;

import javax.swing.*;
import java.awt.*;

public class UserGUI  implements UserInterface {

  private GameInterface game;
  private JLabel promptLabel;
  private JFrame ticTacToeFrame;
  private int boardSize;
  private JButton[][] buttons;

  public UserGUI(GameInterface game) {
    this.game = game;
    promptLabel = new JLabel("xyzxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    ticTacToeFrame = new JFrame("Tic Tac Toe");
    ticTacToeFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    ticTacToeFrame.getContentPane().setLayout(new BorderLayout());
    boardSize = game.getBoardSize();
    JPanel centerPanel = new JPanel();
    centerPanel.setLayout(new GridLayout(boardSize,boardSize));
    buttons = new JButton[boardSize][boardSize];
    for (int i=0;i<boardSize;i++)
      for (int j=0;j<boardSize;j++) {
        buttons[i][j] = makeButton("XYZ");
        centerPanel.add(buttons[i][j]);
      }
    ticTacToeFrame.getContentPane().add(centerPanel, BorderLayout.CENTER);
    ticTacToeFrame.getContentPane().add(promptLabel, BorderLayout.SOUTH);
    ticTacToeFrame.pack();
    ticTacToeFrame.setVisible(true);
    game.join(this);
  }

  public JButton makeButton(String lab) {
    JButton but;
    but = new JButton(lab);
    return but;
  }


  public void displayBoard(char[][] board){
    for (int i=0;i<boardSize;i++)
      for (int j=0;j<boardSize;j++)
        buttons[i][j].setText(""+board[i][j]);

  }

 public void promptForMove() {
   promptLabel.setText("Please make a move");
 }

 public void gameOver(char winner) {

 }

}
