package arrayclasses;

import java.util.*;

public class ClassList {

  private final int MAX_SIZE = 5;

  private String title;
  private String discipline;
  private int number;
  private String instructor;
  private String semester;
  private ArrayList<StudentGrade> students;
//  private int numStudents = 0;

  public ClassList(String title, String discipline, int number,
                   String instructor, String semester) {
    this.title = title;
    this.discipline = discipline;
    this.number = number;
    this.instructor = instructor;
    this.semester = semester;
    students = new ArrayList<StudentGrade>();
  }

  public void addStudent(StudentGrade studentGrade) {
    students.add(studentGrade);
  }

  public double findGrade(String id) {
    for (int i = 0; i < students.size(); i++)
      if (((StudentGrade)students.get(i)).getStudentID().equals(id))
        return students.get(i).getGrade();
    return -1;
  }

  public int findStudentPosition(String id) {
    for (int i = 0; i < students.size(); i++)
      if (students.get(i).getStudentID().equals(id))
        return i;
    return -1;

  }

  public void removeStudent(String id) {
     int pos;
     pos = findStudentPosition(id);
     if (pos == -1)
       return;
     students.remove(pos);
  }

  public void showStudents() {
    System.out.println("The number of students is " + students.size());
    for (int i = 0; i < students.size(); i++)
      System.out.println(students.get(i));

  }

  public String toString() {
    return title + " " + discipline + " " + number + " " + instructor + " " +
        semester + " enrollment: " + students.size();
  }
}
