package arrayclasses;

public class ClassList {

  private final int MAX_SIZE = 5;

  private String title;
  private String discipline;
  private int number;
  private String instructor;
  private String semester;
  private StudentGrade[] students;
  private int numStudents = 0;

  public ClassList(String title, String discipline, int number,
                   String instructor, String semester) {
    this.title = title;
    this.discipline = discipline;
    this.number = number;
    this.instructor = instructor;
    this.semester = semester;
    students = new StudentGrade[MAX_SIZE];
  }

  public void addStudent(StudentGrade studentGrade) {
    students[numStudents] = studentGrade;
    numStudents++;
  }

  public double findGrade(String id) {
    for (int i = 0; i < numStudents; i++)
      if (students[i].getStudentID().equals(id))
        return students[i].getGrade();
    return -1;
  }

  public int findStudentPosition(String id) {
    for (int i = 0; i < numStudents; i++)
      if (students[i].getStudentID().equals(id))
        return i;
    return -1;

  }

  public void removeStudent(String id) {
     int pos;
     pos = findStudentPosition(id);
     if (pos == -1)
       return;
     for (int i=pos;i<numStudents-1;i++)
       students[i] = students[i+1];
     numStudents--;
  }

  public void showStudents() {
    System.out.println("The number of students is " + numStudents);
    for (int i = 0; i < numStudents; i++)
      System.out.println(students[i]);

  }

  public String toString() {
    return title + " " + discipline + " " + number + " " + instructor + " " +
        semester + " enrollment: " + numStudents;
  }
}
