package scholar;

import java.text.*;

public class Scholar implements Comparable {

    private String fullName;
    private double gradePointAverage;
    private int essayScore;
    private int creditHours;
    private boolean scienceMajor;
    private String lastFirstName;
    private DecimalFormat twoPlaces;

    public Scholar(String fullName, double gradePointAverage, int essayScore,
                   int creditHours, boolean scienceMajor) {
        this.fullName = fullName;
        this.gradePointAverage = gradePointAverage;
        this.essayScore = essayScore;
        this.creditHours = creditHours;
        this.scienceMajor = scienceMajor;
        twoPlaces = new DecimalFormat("0.00");
        setLastFirstName();
    }

    public String getFullName() {
        return fullName;
    }

    public double getGradePointAverage() {
        return gradePointAverage;
    }

    public int getEssayScore() {
        return essayScore;
    }

    public int getCreditHours() {
        return creditHours;
    }

    public boolean isScienceMajor() {
        return scienceMajor;
    }

    public double getScore() {
        double score;
        score = 5 * gradePointAverage + essayScore;
        if (scienceMajor) {
            score = score + 0.5;
        }
        if (creditHours < 60)
            return score;
        if (creditHours < 90)
            return score + 0.5;
        return score + 0.75;
    }

    public int compareTo(Object obj) {
        double scoreDif;
        Scholar otherScholar = (Scholar) obj;
        scoreDif = getScore() - otherScholar.getScore();
        if (scoreDif > 0)
            return 1;
        if (scoreDif < 0)
            return -1;
        return 0;
    }

    public static Scholar max(Scholar s1, Scholar s2) {
        if (s1.compareTo(s2) >= 0)
            return s1;
        return s2;
    }

    public static Scholar max(Scholar s1, Scholar s2, Scholar s3) {
        return max(max(s1,s2),s3);
    }

    public String toString() {
        return "Name: " + lastFirstName + ", GPA: " +
                twoPlaces.format(gradePointAverage) + ", essay: " + essayScore +
                ", SCH: " + creditHours + ", science: " +
                trueFalseToYN(scienceMajor);
    }

    private void setLastFirstName() {
        int ind = -1;
        for (int i = 0; i < fullName.length(); i++) {
            if (fullName.charAt(i) == ' ')
                ind = i;
        }
        if (ind == -1)
            lastFirstName = fullName;
        else
            lastFirstName = fullName.substring(ind + 1) + ", " +
                            fullName.substring(0, ind);
    }

    private char trueFalseToYN(boolean f) {
        if (f)
            return 'Y';
        return 'N';
    }
}
