package vehicle;

public class VehicleTester {
  public static void main(String[] args) {
    System.out.println("This program was written by S. Robbins");
    Tire tire = new Tire("abcdefg", 40.0, 35.5);
    System.out.println("Created new tire: " + tire);
    System.out.println("  Serial number " + tire.getSerial());
    System.out.println("  Optimum pressure: " + tire.getOptimumPressure());
    System.out.println("  Current pressure: " + tire.getCurrentPressure());
    tire.setCurrentPressure(99.2);
    System.out.println("  After setting pressure to 99.2, pressure is " +
                       tire.getCurrentPressure());
    Tire tire1 = tire.duplicate();
    System.out.println("  Checking if duplicate tire is equal to original: " +
                       tire.equals(tire1));
    System.out.println();

    Tire[] tires = new Tire[4];
    tires[0] = new Tire("abc", 20.0, 21.9);
    tires[1] = new Tire("xyz", 30.2, 32.2);
    tires[2] = new Tire("my tire", 40.1, 40.0);
    tires[3] = new Tire("last tire", 40.2, 40.3);
    Vehicle vehicle = new Vehicle("CS1713 Rules", tires);
    System.out.println(vehicle);
    Tire[] newTires = vehicle.getTires();
    System.out.println("Result of getting the tires of this vehicle:");
    for (int i = 0; i < newTires.length; i++)
      System.out.println("   " + newTires[i]);
    System.out.println("License is " + vehicle.getLicense());
    System.out.println("Number of over pressure tires: " +
                       vehicle.numberOverPressure());
    System.out.println();

    Vehicle newVehicle = new Vehicle(vehicle.getLicense(), tires);
    System.out.println("Vehicle equals new one: " + vehicle.equals(newVehicle));
    vehicle.replaceTire("xyz", tire);
    System.out.println("After replacing a tire, vehicle equals new one: " +
                       vehicle.equals(newVehicle));
  }
}
