package vehicle;

public class Vehicle {
  private String license;
  private Tire[] tires;

  public Vehicle(String license, Tire[] tires) {
    this.license = license;
    this.tires = new Tire[tires.length];
    for (int i=0;i<tires.length;i++)
      this.tires[i] = tires[i].duplicate();
  }

  public String getLicense() {
    return license;
  }

  public Tire[] getTires() {
    Tire[] newTires = new Tire[tires.length];
    for (int i=0;i<tires.length;i++)
      newTires[i] = tires[i].duplicate();
    return newTires;
  }

  public int numberOverPressure() {
    int count = 0;
    for (int i=0;i<tires.length;i++)
      if (tires[i].overPressure())
        count++;
    return count;
  }

  public void replaceTire(String serialNum, Tire newTire) {
    for (int i=0;i<tires.length;i++)
      if (tires[i].getSerial().equals(serialNum)) {
        tires[i] = newTire;
        return;
      }
  }

  public boolean equals(Vehicle v) {
    if (!v.license.equals(license))
      return false;
    if (v.tires.length != tires.length)
      return false;
    for (int i=0;i<tires.length;i++)
      if (!v.tires[i].getSerial().equals(tires[i].getSerial()))
        return false;
    return true;
  }

  public String toString() {
    String s;
    String plural = "s";
    if (tires.length == 1)
      plural = "";
    s = "Vehicle with license "+license+", "+tires.length+" tire"+plural+"";
    for (int i=0;i<tires.length;i++) {
      if (i == 0)
        s = s + ":";
      else
        s = s + ",";
      s = s + " " +tires[i];
    }
    return s;
  }

}
