package vehicle;

public class Tire {
  private String serial;
  private double optimumPressure;
  private double currentPressure;

  public Tire(String serial, double optimumPressure, double currentPressure) {
    this.serial = serial;
    this.optimumPressure = optimumPressure;
    this.currentPressure = currentPressure;
  }

  public String getSerial() {
    return serial;
  }

  public double getOptimumPressure() {
    return optimumPressure;
  }

  public double getCurrentPressure() {
    return currentPressure;
  }

  public void setCurrentPressure(double currentPressure) {
    this.currentPressure = currentPressure;
  }

  public boolean overPressure() {
    return currentPressure > optimumPressure;
  }

  public boolean equals(Tire t) {
    return t.serial == serial;
  }

  public Tire duplicate() {
    Tire tire = new Tire(serial,optimumPressure,currentPressure);
    return tire;
  }

  public String toString() {
    return "Tire with serial number " + serial + ", optimum pressure " +
        optimumPressure + ", current pressure " + currentPressure;
  }

}
