package circle;

public class Circle {

  private double radius;
  private double x;
  private double y;

  public Circle(double radius, double x, double y) {
    this.radius = radius;
    this.x = x;
    this.y = y;
  }

  public double getRadius() {
    return radius;
  }

  public double getX() {
    return x;
  }

  public double getY() {
    return y;
  }

  public double getArea() {
    return Math.PI * radius * radius;
  }

  public double getCircumference() {
    return 2 * Math.PI * radius;
  }

  public boolean equals(Circle c) {
    return c.getRadius() == radius && c.getX() == x && c.getY() == y;
  }

// return true if c is strictly inside this circle
  public boolean inside(Circle c) {
    return getDistance(c) < radius - c.getRadius();
  }

  public boolean intersects(Circle c) {
    double d = getDistance(c);
    return d <= radius + c.getRadius() && d >= Math.abs(radius - c.getRadius());
  }

  public double areaOfIntersection(Circle c) {
    double r1;
    double r2;
    double angle1;
    double angle2;
    double area1;
    double area2;
    if (equals(c))
      return getArea();
    else if (inside(c))
      return c.getArea();
    else if (c.inside(this))
      return getArea();
    else if (!intersects(c))
      return 0;
    r1 = radius;
    r2 = c.getRadius();
    angle1 = getAngle(c);
    angle2 = c.getAngle(this);
//  Handle tangent inside separately
    if ( (angle1 == 0) && ( (getD1(c) > getDistance(c)) || (getD1(c) < 0)))
      return Math.min(getArea(), c.getArea());
    area1 = r1 * r1 * 0.5 * (angle1 - Math.sin(angle1));
    area2 = r2 * r2 * 0.5 * (angle2 - Math.sin(angle2));
    return area1 + area2;
  }

  public String toString() {
    return "Circle with center at (" + x + "," + y + ") and radius " + radius;
  }


//   Private methods follow:

// return the distance between the centers of this circle and the parameter
  private double getDistance(Circle c) {
    double deltaX;
    double deltaY;
    deltaX = c.getX() - x;
    deltaY = c.getY() - y;
    return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
  }

// return the distance from the center of this circle to the chord of intersection
// The value will only be valid if the circles intersect.
  private double getD1(Circle c) {
    double r1, r2, d;
    r1 = radius;
    r2 = c.getRadius();
    d = getDistance(c);
    if (d == 0)
      return 0;
    return (r1 * r1 - r2 * r2 + d * d) / (2 * d);
  }

// return the length of the chord of intersection
// Only call this method if the circles actually intersect.
  private double getChord(Circle c) {
    double r1, d1;
    r1 = radius;
    d1 = getD1(c);
    if (r1 < d1)
      return 0;
    return 2 * Math.sqrt(r1 * r1 - d1 * d1);
  }

// return the central angle of the chord of intersection
// note: this method returns the desired angle even when it is greater than PI
  private double getAngle(Circle c) {
    double chord;
    double d1;
    d1 = getD1(c);
    if (Math.abs(d1) > radius)
      return 0;
    chord = getChord(c);
    if (chord == 0)
      return 0;
    return 2 * Math.acos(d1 / radius);
  }

}
