package studentrecord;

import java.util.*;

public class StudentRecord {

  private static final String[] VALID_GRADES =
      {"A","A-","B+","B","B-","C+","C","C-","D","F","IN"};
  private static final double[] GRADE_POINTS =
      {4.0,3.7,3.3,3.0,2.7,2.3,2.0,1.7,1.0,0.0,-1.0};

  private String name;
  private String id;
  private int numCoursesTaken;
  private String[] grades;

  public StudentRecord(String name, String id, int maxCourses) {
    this.name = name;
    this.id = id;
    grades = new String[maxCourses];
    numCoursesTaken = 0;
  }

  public String getName() {
    return name;
  }

  public String getId() {
    return id;
  }

  public int getMaxCourses() {
    return grades.length;
  }

  public int getNumCoursesTaken() {
    return numCoursesTaken;
  }

  public String getGrade(int n) {
    if (n < 0 || n >= numCoursesTaken)
      return "invalid";
    return grades[n];
  }

  public double getGPA() {
    int numCreditGrades = 0;
    double gradePointsTotal = 0;
    double gradePoints;
    for (int i=0;i<numCoursesTaken;i++) {
      gradePoints = getGradePoints(grades[i]);
      if (gradePoints >= 0) {
        gradePointsTotal += gradePoints;
        numCreditGrades++;
      }
    }
    if (numCreditGrades == 0)
      return 0.0;
    return gradePointsTotal/numCreditGrades;
  }

  public boolean addGrade(String grade) {
    if (numCoursesTaken == grades.length)
      return false;
    if (!validGrade(grade))
      return false;
    grades[numCoursesTaken] = grade;
    numCoursesTaken++;
    return true;
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append("name: "+name);
    sb.append(", id: "+id);
    sb.append(", courses: [");
    for (int i=0;i<numCoursesTaken;i++)
      if (i < numCoursesTaken - 1)
      sb.append(grades[i] + ", ");
      else
        sb.append(grades[i] + "]");
    return sb.toString();
  }

  private boolean validGrade(String grade) {
    for (int i=0;i<VALID_GRADES.length;i++)
      if (VALID_GRADES[i].equals(grade))
        return true;
    return false;
  }

  private double getGradePoints(String s) {
    for (int i=0;i<VALID_GRADES.length;i++)
      if (VALID_GRADES[i].equals(s))
        return GRADE_POINTS[i];
    return -1.0;
  }

}
