package applets;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;

public class BoxApplet
    extends JApplet {
  boolean isStandalone = false;
  BorderLayout borderLayout1 = new BorderLayout();

  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
        (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public BoxApplet() {
  }

  public void paint(Graphics g) {
    int x = 10;
    int y = 20;
    int w = 200;
    int h = 100;
    int inset = 5;
    drawX(g,x,y,w,h,inset);
  }

  private void drawX(Graphics g, int x, int y, int width, int height, int inset) {
    Graphics gTemp = g.create();
    gTemp.setColor(Color.black);
    gTemp.drawRect(x,y,width,height);
    gTemp.setColor(Color.yellow);
    gTemp.fillRect(x+1,y+1,width-1,height-1);
    gTemp.setColor(Color.red);
    gTemp.drawRect(x+inset, y+inset,width-2*inset,height-2*inset);
    gTemp.dispose();

  }


  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception {
    this.setSize(new Dimension(400, 300));
    this.getContentPane().setLayout(borderLayout1);
  }

  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }

  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }

  //static initializer for setting look & feel
  static {
    try {
      //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }
    catch (Exception e) {
    }
  }
}
