package sort;

public class QuadraticSort {

  public static void selectionSort(int[] list) {
  for (int index = 0; index < list.length - 1; index++) {
    int min = findMinPosition(list, index);
    int temp = list[min];
    list[min] = list[index];
    list[index] = temp;
  }
}

private static int findMinPosition(int[] list, int start) {
  int min = start;
  for (int scan = start + 1; scan < list.length; scan++)
    if (list[min] > list[scan])
      min = scan;
  return min;
}


  public static void selectionSort(Comparable[] list) {
    for (int index = 0; index < list.length - 1; index++) {
      int min = findMinPosition(list, index);
      Comparable temp = list[min];
      list[min] = list[index];
      list[index] = temp;
    }
  }

  private static int findMinPosition(Comparable[] list, int start) {
    int min = start;
    for (int scan = start + 1; scan < list.length; scan++)
      if (list[min].compareTo(list[scan]) > 0)
        min = scan;
    return min;
  }

  public static void insertionSort(int[] list) {
  for (int index = 1; index < list.length; index++) {
    insertItem(list, index);
  }
}

private static void insertItem(int[] list, int index) {
  int key = list[index];
  int position = index;

  // shift larger values to the right
  while (position > 0 && (key <list[position - 1])) {
    list[position] = list[position - 1];
    position--;
  }
  list[position] = key;
}


  public static void insertionSort(Comparable[] list) {
    for (int index = 1; index < list.length; index++) {
      insertItem(list, index);
    }
  }

  private static void insertItem(Comparable[] list, int index) {
    Comparable key = list[index];
    int position = index;

    // shift larger values to the right
    while (position > 0 && key.compareTo(list[position - 1]) < 0) {
      list[position] = list[position - 1];
      position--;
    }
    list[position] = key;
  }

  public static void bubbleSort(int[] list) {
    for (int i=0;i<list.length - 1;i++)
      if (!bubbleSortOnePass(list, list.length - i))
        break;
  }

  // return true if an interchange was made
  private static boolean bubbleSortOnePass(int[] list, int size) {
    boolean interchange = false;
    for (int i=0;i<size-1;i++)
      if (list[i] > list[i+1]) {
        int temp = list[i];
        list[i] = list[i+1];
        list[i+1] = temp;
        interchange = true;
      }
    return interchange;
  }

}
