package shape;

public abstract class Shape implements Comparable {
  private String name;

  public Shape(String shapeName) {
    name = shapeName;
  }

  abstract public double getArea(); // Provided by sub-class

  public String getName() {
    return name;
  }

  public int compareTo(Object obj) {
    Shape otherObj = (Shape) obj;
    if (getArea() < otherObj.getArea()) {
      return -1;
    }
    else if (getArea() > otherObj.getArea()) {
      return 1;
    }
    else {
      return 0;
    }
  }

  public String toString() {
    return name + ":area=" + getArea();
  }
}
