package arrayclasses;

import java.util.*;

public class ClassList {
  private String title;
  private String discipline;
  private int courseNumber;
  private String instructor;
  private String semester;
  private int classCapacity;
  private ArrayList students;

  public ClassList(String title, String discipline, int courseNumber,
                   String instructor, String semester) {
    this.title = title;
    this.discipline = discipline;
    this.courseNumber = courseNumber;
    this.instructor = instructor;
    this.semester = semester;
    this.classCapacity = classCapacity;
    students = new ArrayList();
  }

  public boolean addStudent(String id) {
    StudentGrade student;
    if (findStudent(id) != null)
      return false;
    student = new StudentGrade(id, 0);
    students.add(student);
    return true;
  }

  public StudentGrade findStudent(String id) {
    for (int i = 0; i < students.size(); i++)
      if (((StudentGrade)(students.get(i))).getStudentID().equals(id))
        return (StudentGrade)students.get(i);
    return null;
  }

  private int findStudentIndex(String id) {
    for (int i = 0; i < students.size(); i++)
      if (((StudentGrade)(students.get(i))).getStudentID().equals(id))
        return i;
    return -1;
  }

  public boolean removeStudent(String id) {
    int index;
    index = findStudentIndex(id);
    if (index == -1)
      return false;
    students.remove(index);
    return true;
  }

  // return -1 if no students
  public double getAverageGrade() {
    double sum = 0;
    if (students.size() == 0)
      return -1;
    for (int i=0;i<students.size();i++)
      sum = sum + ((StudentGrade)students.get(i)).getGrade();
    return sum/students.size();
  }

  // if no students, max grade is 0
  public double getMaxGrade() {
    double max;
    if (students.size() == 0)
      return 0;
    max = ((StudentGrade)students.get(0)).getGrade();
    for (int i=1;i<students.size();i++)
      if (max < ((StudentGrade)students.get(i)).getGrade())
        max = ((StudentGrade)students.get(i)).getGrade();
    return max;
  }

  // if no students, max grade is 0
  public double getMinGrade() {
    double min;
    if (students.size() == 0)
      return 0;
    min = ((StudentGrade)students.get(0)).getGrade();
    for (int i=1;i<students.size();i++)
      if (min > ((StudentGrade)students.get(i)).getGrade())
        min = ((StudentGrade)students.get(i)).getGrade();
    return min;
  }

  public String toString() {
    String s;
    s = "ClassList with number of students = " + students.size();
    for (int i=0;i<students.size();i++)
      s = s + "\n" + students.get(i);
    return s;
  }

}
