package arrayclasses;

import java.util.*;

public class ClassListTester {

  private static Scanner scan;
  private static ClassList classList;

  public static void main(String[] args) {
    scan = new Scanner(System.in);
    boolean doneFlag = false;
    int whatToDo;
    classList = new ClassList("Intro to Computer Science", "CS", 1713,
                              "S. Robbins", "Fall 2005", 30);
    System.out.println("Created new class list:\n" + classList);
    while (!doneFlag) {
      System.out.println("What do you want to do?");
      System.out.println("1) Add a student");
      System.out.println("2) Remove a student");
      System.out.println("3) Find a student");
      System.out.println("4) Change a grade");
      System.out.println("5) Show the list");
      System.out.println("6) Create some students with grades");
      System.out.println("7) Show class statistics");
      System.out.println("8) Exit");
      whatToDo = scan.nextInt();
      scan.nextLine();
      switch (whatToDo) {
        case 1:
          addAStudent();
          break;
        case 2:
          removeAStudent();
          break;
        case 3:
          findAStudent();
          break;
        case 4:
          changeAGrade();
          break;
        case 5:
          showList();
          break;
        case 6:
          createSomeStudents();
          break;
        case 7:
          showStatistics();
          break;
        case 8:
          doneFlag = true;
          break;
        default:
          System.out.println("Entry must be between 1 and 4, try again!");
      }
    }
    System.out.println("Have a good day!");
  }

  private static void addAStudent() {
    String id;
    System.out.println("Enter the ID of a new student:");
    id = scan.nextLine();
    if (classList.addStudent(id))
      System.out.println("New student added successfully");
    else
      System.out.println("Could not add student with id " + id);
  }

  private static void showList() {
    System.out.println(classList.toString());
  }

  private static void changeAGrade() {
    String id;
    double grade;
    StudentGrade student;
    System.out.println(
        "Enter the ID of the student whose grade you want to change:");
    id = scan.nextLine();
    student = classList.findStudent(id);
    if (student == null) {
      System.out.println("Could not find student with id " + id);
      return;
    }
    System.out.println("Current grade for the student with id" + id + "is " +
                       student.getGrade());
    System.out.println("Enter a new grade for this student: ");
    grade = scan.nextDouble();
    scan.nextLine();
    student.setGrade(grade);
    System.out.println("Grade changed to " + student.getGrade());
  }

  private static void removeAStudent() {
    String id;
    System.out.println(
        "Enter the ID of the student you want to remove:");
    id = scan.nextLine();
    if (classList.removeStudent1(id))
      System.out.println("Student removed successfully");
    else
      System.out.println("Failed to removed the student with id " + id);
  }

  private static void findAStudent() {
    String id;
    StudentGrade student;
    System.out.println(
        "Enter the ID of the student you want to find:");
    id = scan.nextLine();
    student = classList.findStudent(id);
    if (student == null)
      System.out.println("student with id " + id + " was not found");
    else
      System.out.println(student.toString());
  }

  private static void showStatistics() {
    System.out.println("Statistics follow:");
    System.out.println("Average grade: "+classList.getAverageGrade());
    System.out.println("Max grade: "+classList.getMaxGrade());
    System.out.println("Min grade: "+classList.getMinGrade());
  }

  private static void createSomeStudents() {
    classList.addStudent("abc");
    classList.addStudent("def");
    classList.addStudent("xyz");
    classList.addStudent("myId");
    classList.addStudent("newId");
    classList.findStudent("abc").setGrade(3.14);
    classList.findStudent("def").setGrade(6.02214E23);
    classList.findStudent("xyz").setGrade(1.618);
    classList.findStudent("myId").setGrade(2.71828);
    classList.findStudent("newId").setGrade(1.41421356);
  }

}
