package arrayclasses;

public class ClassList {
  private String title;
  private String discipline;
  private int courseNumber;
  private String instructor;
  private String semester;
  private int classCapacity;
  private StudentGrade[] students;
  private int numStudents;

  public ClassList(String title, String discipline, int courseNumber,
                   String instructor, String semester, int classCapacity) {
    this.title = title;
    this.discipline = discipline;
    this.courseNumber = courseNumber;
    this.instructor = instructor;
    this.semester = semester;
    this.classCapacity = classCapacity;
    students = new StudentGrade[classCapacity];
    numStudents = 0;
  }

  public boolean addStudent(String id) {
    StudentGrade student;
    if (findStudent(id) != null || (numStudents >= classCapacity))
      return false;
    student = new StudentGrade(id, 0);
    students[numStudents] = student;
    numStudents++;
    return true;
  }

  public StudentGrade findStudent(String id) {
    for (int i = 0; i < numStudents; i++)
      if (students[i].getStudentID().equals(id))
        return students[i];
    return null;
  }

  private int findStudentIndex(String id) {
    for (int i = 0; i < numStudents; i++)
      if (students[i].getStudentID().equals(id))
        return i;
    return -1;
  }

  public boolean removeStudent(String id) {
    int index;
    index = findStudentIndex(id);
    if (index == -1)
      return false;
    if (index != numStudents - 1)
      students[index] = students[numStudents - 1];
    numStudents--;
    return true;
  }

  public boolean removeStudent1(String id) {
    int index;
    index = findStudentIndex(id);
    if (index == -1)
      return false;
    for (int i = index; i < numStudents - 1; i++)
      students[i] = students[i + 1];
    numStudents--;
    return true;
  }

  // return -1 if no students
  public double getAverageGrade() {
    double sum = 0;
    if (numStudents == 0)
      return -1;
    for (int i=0;i<numStudents;i++)
      sum = sum + students[i].getGrade();
    return sum/numStudents;
  }

  // if no students, max grade is 0
  public double getMaxGrade() {
    double max;
    if (numStudents == 0)
      return 0;
    max = students[0].getGrade();
    for (int i=1;i<numStudents;i++)
      if (max < students[i].getGrade())
        max = students[i].getGrade();
    return max;
  }

  // if no students, max grade is 0
  public double getMinGrade() {
    double min;
    if (numStudents == 0)
      return 0;
    min = students[0].getGrade();
    for (int i=1;i<numStudents;i++)
      if (min > students[i].getGrade())
        min = students[i].getGrade();
    return min;
  }

  public String toString() {
    String s;
    s = "ClassList with number of students = " + numStudents;
    for (int i=0;i<numStudents;i++)
      s = s + "\n" + students[i];
    return s;
  }

}
