package arrayutility;

public class ArrayUtility {

  public static void printForwards(int[] array) {
    for (int i = 0; i < array.length; i++)
      System.out.print(array[i] + " ");
    System.out.println();
  }

  public static void printBackwards(int[] array) {
    for (int i = array.length - 1; i >= 0; i--)
      System.out.print(array[i] + " ");
    System.out.println();
  }

  public static int getSum(int[] array) {
    int sum = 0;
    for (int i = 0; i < array.length; i++)
      sum = sum + array[i];
    return sum;
  }

  public static double getAverage(int[] array) {
    if (array.length == 0)
      return 0.0;
    return getSum(array) / (double) array.length;
  }

  public static int getMax(int[] array) {
    int max;
    if (array.length == 0)
      return Integer.MIN_VALUE;
    max = array[0];
    for (int i = 1; i < array.length; i++)
      if (array[i] > max)
        max = array[i];
    return max;
  }

  public static int[] reverse(int[] array) {
    int[] newArray;
    int j;
    newArray = new int[array.length];
    j = 0;
    for (int i = array.length - 1; i >= 0; i--) {
      newArray[j] = array[i];
      j++;
    }
    return newArray;
  }

  public static int[] reverse1(int[] array) {
    int[] newArray;
    newArray = new int[array.length];
    for (int i = array.length - 1; i >= 0; i--)
      newArray[array.length - 1 - i] = array[i];
    return newArray;
  }

  public static int[] reverse2(int[] array) {
    int[] newArray;
    newArray = new int[array.length];
    for (int i = 0; i < array.length; i++)
      newArray[i] = array[array.length - i - 1];
    return newArray;
  }

  public static int find(int[] array, int target) {
    for (int i = 0; i < array.length; i++)
      if (array[i] == target)
        return i;
    return -1;
  }

  // reverses the array
  public static void reverseInPlace(int[] array) {
    int count = 0;
    int temp;
    for (int i = array.length - 1; i > count; i--) {
      temp = array[i];
      array[i] = array[count];
      array[count] = temp;
      count++;
    }
  }

}
