package house;

import java.util.*;

public class HouseTest {
  public static void main(String[] args) {
    Scanner scan = new Scanner(System.in); //Only 1 scanner object is needed.
    String name;
    double width=0;
    double length=0;
    boolean invalidEntry;
    House house = new House();

    System.out.println("Welcome to Project 2 by Carola Wenk");
    System.out.println("In the following, enter a list of rooms you have in your house.");
    while(house.roomsAvailable() > 0){//Check with roomsAvailable(); don't simply run
                                      //a for-loop with 10 iterations
      invalidEntry=false;
      System.out.println("Enter a room ---------------------------");
      System.out.print("   Enter room name (\"no more room\" to quit): ");
      name=scan.nextLine();
      if(name.equals("no more room")){
        break;
      }
      System.out.print("   Enter room width  (ft; should be positive number): ");
      width=scan.nextDouble();
      scan.nextLine(); //read trailing \n
      if(width<=0){
        invalidEntry=true; //'jumps' to the end of the loop body
        System.out.println("Invalid entry. This room will not be added.");
      }

      if(!invalidEntry){ //'jumps' to the end of the loop body
        System.out.print("   Enter room length (ft; should be positive number): ");
        length = scan.nextDouble();
        scan.nextLine(); //read trailing \n
        if (length <= 0) {
          invalidEntry = true;
          System.out.println("Invalid entry. This room will not be added.");
        }
      }

      if(!invalidEntry){ // length>0 && width>0
        house.addRoom(name, width, length);
      }
      System.out.println();
    }
    System.out.println();
    System.out.print("Please input the total cost of your house: ($K): ");
    house.setPrice(scan.nextDouble());
    scan.nextLine(); //read trailing \n
    // finished reading house input

    System.out.println();
    System.out.println(house);
    System.out.println();
    System.out.print("Please enter the name of a room: ");
    Room room = house.findRoom(scan.nextLine());
    if(room==null)
      System.out.println("Room not found.");
    else
      System.out.println(room);
  }
}
