package house;

public class House {
  private final int MAX_ROOMS = 10;  // maximum number of rooms in the house
  private Room[] roomArray;          // an array of Room objects
  private int count;                 // the number of rooms stored in the array
  private double price;              // the price of the house


  public House() {
    count=0;
    roomArray = new Room[MAX_ROOMS];
  }

  public String toString(){
    String string = "**********************************************************\n"
        +"You have the following rooms in your house:\n";
    for(int i=0;i<count;i++){
      string+=roomArray[i]+"\n";
    }
    string+="\nThe total area in your house is "+getArea()+
        " sqft with averate cost "+getAverageCost()+"/sqft.";

    return string;
  }

  public void addRoom(Room newRoom){
    roomArray[count]=newRoom;
    count++;
  }

  public void addRoom(String name, double width, double length){
    addRoom(new Room(name, width, length));
  }

  private double getArea(){
    double sum=0;
    for(int i=0;i<count;i++){
      sum+=roomArray[i].getArea();
    }
    return sum;
  }

  public int roomsAvailable(){
    return MAX_ROOMS-count;
  }


  private double getAverageCost(){
    return price*1000/getArea();
  }

  public Room findRoom(String name){
    for(int i=0;i<count;i++){
      if(name.equals(roomArray[i].getName()))
        return roomArray[i];
    }
    return null;
  }

  public void setPrice(double price){
    this.price=price;
  }
}
