package triangle;


// Triangle class written by S. Robbins, September 2005
public class Triangle {

  private double side1;
  private double side2;
  private double side3;

  public Triangle(double s1, double s2, double s3) {
    side1 = s1;
    side2 = s2;
    side3 = s3;
  }

  public double getSide1() {
    return side1;
  }

  public double getSide2() {
    return side2;
  }

  public double getSide3() {
    return side3;
  }

// These inequalities imply that the sides are positive
  public boolean isValid() {
    return (side3 < side1 + side2) && (side2 < side1 + side3) &&
        (side1 < side2 + side3);
  }

// A scalene triangle is a valid triangle with no two sides equal
  public boolean isScalene() {
    if (!isValid())
      return false;
    return (side1 != side2) && (side2 != side3) && (side1 != side3);
  }

// An isoceles triangle is a valid triangle with exactly 2 sides equal
  public boolean isIsoceles() {
    if (!isValid() || isEquilateral())
      return false;
    return (side1 == side2) || (side2 == side3) || (side1 == side3);
  }

// All equalilateral trianlges are valid if the sides are positive
  public boolean isEquilateral() {
    return (side1 > 0) && (side1 == side2) && (side2 == side3);
  }

// Use Heron's formula if the triangle is valid.  Otherwise, return 0
  public double getArea() {
    double s;
    if (!isValid())
      return 0.0;
    s = (side1 + side2 + side3)/2.0;
    return Math.sqrt(s*(s-side1)*(s-side2)*(s-side3));
  }

// This just returns information about the sides
  public String toString() {
    return "Triangle with sides "+side1 + ", "+side2+" and "+side3;
  }

// This returns information about the type of triangle
  public String getTypeString() {
    if (!isValid())
      return "an invalid triangle";
    if (isScalene())
      return "a scalene triangle";
    if (isIsoceles())
      return "an isoceles triangle";
    if (isEquilateral())
      return "an equilateral triangle";
    return "unknown triangle type";
  }

}
